/*************************************************/
/* Examples Program For "ET-dsPIC30F2010"  Board */
/* Hardware    : ET-dsPIC30F2010 TRAINING KIT V1 */
/* Target MCU  : dsPIC30F2010                    */
/*       	   : X-TAL : 7.3728 MHz              */
/*             : Run 117.9648MHz                 */
/*             : Selec OSC Mode = XT w/PLL 16x   */
/* Compiler    : MPLAB + C30 V1.33  		     */
/* Last Update : 1/October/2005                  */
/* Function    : Example Use UART = 9600 BPS     */
/*************************************************/
/* Used RC13 = TXD                               */
/* Used RC14 = RXD                               */
/*************************************************/

#include "p30f2010a2.h"	                               		// For dsPIC30F2010 MPU Register
#include "uart.h"											// Used UART Config
#include "stdio.h"											// Used "sprintf" Function

/* Setup Configuration For ET-dsPIC30F2010 */
_FOSC(CSW_FSCM_ON & XT_PLL16);								// Enable Clock Switching,Enable Fail-Salf Clock
                                                            // Closk Source = Primary XT + (PLL x 16)
_FWDT(WDT_OFF);												// Disable Watchdog 
_FBORPOR(PBOR_ON & BORV_45 & PWRT_64 & MCLR_EN);			// Enable Brown-Out = 4.5V,Power ON = 64mS,Enable MCLR
_FGS(CODE_PROT_OFF);										// Code Protect OFF
/* End   Configuration For ET-dsPIC30F2010 */

char uart_buf[40]; 											// "sprintf" Buffer

/* pototype  section */
void init_uart(void);										// Initial UART1 Function

int main(void)
{  
  char rx_data;												// Character Receive Buffer

  init_uart();												// Initial UART = 9600,N,8,1

  sprintf(uart_buf,"ET-dsPIC30F2010 TRAINING KIT V1\n\r"); 	// Print Message String 
  putsUART1((unsigned int *)uart_buf);                      // Print uart_buff to UART1
  while(BusyUART1());										// Wait putsUART1 Complete
  
  sprintf(uart_buf,"Demo UART1 RS-232 Interface\n\n\r");	// Print Message String 
  putsUART1((unsigned int *)uart_buf);                      // Print uart_buff to UART1
  while(BusyUART1());										// Wait putsUART1 Complete  

  sprintf(uart_buf,"Press Any Key For Test Echo\n\r"); 		// Print Message String 
  putsUART1((unsigned int *)uart_buf);                      // Print uart_buff to UART1
  while(BusyUART1());										// Wait putsUART1 Complete  

  while(1)													// Loop Continue
  {
    if (DataRdyUART1())										// If RX Receive Complete
    {
      rx_data = ReadUART1();								// Get UART1 Data Receive
      if (rx_data == 0x0D)									// If Receive Enter
      {
        putcUART1(rx_data);									// Echo to TX of UART1
        while(BusyUART1());									// Wait putcUART1 Complete  
        putcUART1(0x0A);									// Auto Line Feed
        while(BusyUART1());									// Wait putcUART1 Complete  
      } 
      putcUART1(rx_data);									// Echo to TX of UART1
      while(BusyUART1());									// Wait putcUART1 Complete  
    }
  } 
}	  

/*********************************/
/* Initial UART for dsPIC30F2010 */
/* 9600,N,8,1 / 117.9648MHz Fosc */
/*********************************/
void init_uart()
{		  
  CloseUART1();												// Disable UART1 Before New Config

  // Config UART1 Interrupt Control
  ConfigIntUART1(UART_RX_INT_DIS &							// Disable RX Interrupt
    		     UART_RX_INT_PR2 &							// RX Interrupt Priority = 2
    		     UART_TX_INT_DIS &							// Disable TX Interrupt
    		     UART_TX_INT_PR3);							// TX Interrupt Priority = 3  
  // Open UART1 = Mode,Status,Baudrate              
  OpenUART1(UART_EN	&										// Enable UART(UART Mode)
            UART_IDLE_STOP &								// Disable UART in IDLE Mode 
 			UART_ALTRX_ALTTX & 								// Select U1TX=RC13,U1RX=RC14
            UART_DIS_WAKE &									// Disable Wake-Up
			UART_DIS_LOOPBACK &								// Disable Loop Back
			UART_DIS_ABAUD &								// Disable Auto Baudrate
  			UART_NO_PAR_8BIT &								// UART = 8 Bit, No Parity
 			UART_1STOPBIT,									// UART = 1 Stop Bit

	  		// Config UART1 Status
  			UART_INT_TX & 									// Select Interrupt After TX Complete
	 		UART_TX_PIN_NORMAL &							// Normal U1TX Mode
 			UART_TX_ENABLE &								// Enable U1TX
 	 		UART_INT_RX_BUF_FUL &							// Flasg Set After RX Complete 
  			UART_ADR_DETECT_DIS &              				// Disable Check Address 
			UART_RX_OVERRUN_CLEAR,							// Clear Overrun Flag

  			// ET-dsPIC30F2010 TRAINING KIT V1.0 Hardware Board
  			// XTAL = 7.3728MHz
  			// Fosc = 7.3728 MHz x 16 = 117.9648 MHz
  			// Fcy(UART) = Fosc / 4 
  			//           = 117.9648 / 4 = 29.4912 MHz
  			// U1BRG = [Fcy/(16xBaud)]-1
  			//       = [29.4912 MHz / (16x9600)] - 1
  			//       = 191 = BFH			
  			191);											// ET-dsPIC30F2010 UART Baudrate = 9600 BPS
}
